<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\FooterModel; // DIPINDAHKAN KE SINI (TIDAK DIHAPUS)

class Home extends BaseController
{
    public function index(): string
    {
        $footerModel = new FooterModel();
        $data['footer'] = $footerModel->first();

        return view('index', $data); // DATA DIKIRIM
    }

    public function berita()
    {
        return view('berita');
    }

    public function galeri()
    {
        $modelGuru   = new \App\Models\GaleriGuruStafModel();
        $modelSiswa  = new \App\Models\SiswaModel();
        $videoModel  = new \App\Models\GaleriVideoModel();
        $ekstraModel = new \App\Models\EkstrakurikulerModel();
    
        $data = [
            'guruItems' => $modelGuru
                ->orderBy('urutan', 'ASC')
                ->orderBy('nama', 'ASC')
                ->findAll(),
    
            'siswaItems' => $modelSiswa
                ->orderBy('kelas_angka', 'DESC')
                ->orderBy('kelas_sub', 'ASC')
                ->orderBy('nama', 'ASC')
                ->findAll(),
    
            'videoItems' => $videoModel
                ->orderBy('id', 'DESC')
                ->findAll(),
    
            'ekstraItems' => $ekstraModel
                ->orderBy('urutan', 'ASC')
                ->findAll(),
        ];
    
        return view('galeri', $data);
    }

    // ================= TENTANG =================
    public function tentang()
    {
        $tentangModel = new \App\Models\TentangSekolahModel();

        $data = [
            'tentangUtama' => $tentangModel
                ->where('tipe', 'tentang')
                ->orderBy('id', 'ASC')
                ->findAll(),

            'nilaiItems' => $tentangModel
                ->where('tipe', 'nilai')
                ->orderBy('id', 'ASC')
                ->findAll(),

            'komitmenItems' => $tentangModel
                ->where('tipe', 'komitmen')
                ->orderBy('id', 'ASC')
                ->findAll(),
        ];

        return view('tentang', $data);
    }
}
